/*jshint unused: vars */
require.config({
	paths: {

		/*                  LIBRARIES                    */
		'angular'						: '../libs/angular/js/angular',
		'angularAnimate'				: '../libs/angular-animate/js/angular-animate',
		'angularBusy'					: '../libs/angular-busy/js/angular-busy',
		'angularSanitize'				: '../libs/angular-sanitize/js/angular-sanitize',
		'angularSnap'					: '../libs/angular-snap/js/angular-snap',
		'angularTouch'					: '../libs/angular-touch/js/angular-touch',
		'angularUiBootstrap'			: '../libs/angular-bootstrap/js/ui-bootstrap-tpls-custom',
		'angularUiBootstrapOverwrites'	: '../libs/angular-bootstrap/js/ui-bootstrap-overwrites',
		'angularUiRouter'				: '../libs/angular-ui-router/js/angular-ui-router',
		'angularUiUtils'				: '../libs/angular-ui-utils/js/ui-utils',
		'clampjs'						: '../libs/Clamp.js/clamp',
        'highstocks'					: '../libs/highstock/js/highstock.src',
		'jQuery'						: '../libs/jquery/js/jquery',
		'lodash'						: '../libs/lodash/js/lodash',
		'moment-timezone'				: '../libs/moment-timezone/js/moment-timezone-with-data',
		'snap'							: '../libs/snap/js/snap',
		'text'							: '../libs/requirejs-text/text',
        'highcharts-3d'					: '../libs/highcharts/js/highcharts-3d.src',
        'highcharts-ng'					: '../libs/highcharts-ng/js/highcharts-ng',
        'solid-gauge'					: '../libs/highcharts/js/solid-gauge.src',
        'moment'						: '../libs/moment/js/moment',
        'HomePageConstants'				: 'modules/home/core/constants',


        'class'							: '../libs/jquery/js/class',
        'jquery-encoder'    : '../libs/jquery/js/jquery-encoder',


        // Left-Hand Nav Feature
        'FitnessModule'                  : 'modules/fitness/fitness_module',
        'FitnessConstants'               : 'modules/fitness/core/fitness_constants',
        'FitnessCongratsConstants'       : 'modules/fitness/core/fitness-congrats_constants',
        'FitnessService'                 : 'modules/fitness/core/fitness_service',
        'FitnessCongratsService'         : 'modules/fitness/core/fitness-congrats_service',
        'FitnessServiceConstants'        : 'modules/fitness/core/fitness_service_constants',
        'FitnessActivityController'      : 'modules/fitness/pages/summary/fitness-activity_controller',
        'GoalHistoryController'			 : 'modules/fitness/pages/summary/goal-history_controller',
        'GoalHistoryGraphService'		 : 'modules/fitness/pages/summary/goal-history-graph_service',
        'FitnessEntryController'         : 'modules/fitness/pages/entry/fitness-entry_controller',
        'FitnessActivityGraphService'    : 'modules/fitness/pages/summary/fitness-activity-graph_service',
        'FitnessNavItemDateFilter'		 : 'modules/fitness/core/fitness-nav-item-date-filter',



        'FitnessRemindersInstanceService'        : 'modules/fitness/core/fitness-reminders-instance_service',
        'FitnessRemindersService'	             : 'modules/fitness/core/fitness-reminders_service',
        'FitnessNotificationStatusController'    : 'modules/fitness/pages/notification-status/fitness-notification-status_controller',


        // Left-Hand Nav Feature
        'WeeklyGoalsService'			: 'modules/home/core/weekly-goals_service',
        'AbstractWeeklyGoalsService'	: 'modules/home/core/abstract-weekly-goals_service',
        'AuthenticatedUserController'	: 'modules/home/pages/authenticated-user/authenticated-user_controller',
        'UnauthenticatedUserController'	: 'modules/home/pages/unauthenticated-user/unauthenticated-user_controller',
        'GoalGraphService'				: 'modules/home/graphs/goal-graphs_service',
        'GoalGraphAccessibilityService' : 'modules/home/graphs/goal-graphs-accessibility_service',
        'SetGoalsModalController'		: 'ui-components/modals/set-goals/set-goals_controller',
        /*                  DECORATORS                    */
		'ngMaskDecoration'				: 'decorations/ui-mask_decorator',
		'uiCollapseDecoration'			: 'decorations/ui-collapse_decorator',
		'ngClickDecoration'				: 'decorations/ng-click_decorator',

		/*                  APPLICATION                    */
		'appConfig'						: 'app-config',
		'app'							: 'app',
		'router'						: 'router',

		//templates is generated by grunt ngtemplate task
		'templates'						: 'templates',
        'global'						: 'core/services/global',
        'AbstractFitnessService'         : 'modules/fitness/core/abstract-fitness_service',

		/*                  CONTAINER                    */
		'MainController'				: 'container/main/main_controller',
		'SplashController'				: 'container/splash/splash_controller',

		'HeaderController'				: 'container/components/header/header_controller',
		'FooterController'				: 'container/components/footer/footer_controller',
		'TwoPanelController'			: 'container/components/content/two-column_controller',
		'List'							: 'container/components/content/list/list_directive',
		'Menu'							: 'container/components/menu/menu_directive',
		'SecondaryNavigationController' : 'container/components/content/secondary-navigation/secondary-navigation_controller',

		/*                  FEATURE SECTIONS                    */

		// Home
		'HomeModule'					: 'modules/home/home_module',
		'LandingController'				: 'modules/home/landing/landing_controller',
		'InitialSettingsController'		: 'modules/home/initial-settings/initial-settings_controller',
        'SupportModule'                  : 'modules/support/support_module',
        'SupportConstants'             	 : 'modules/support/core/support_constants',
        'SupportSummaryController'       : 'modules/support/pages/summary/support-summary_controller',

        // Learn More Left-Hand Nav Feature
        'LearnMoreModule'                   : 'modules/learn-more/learn-more_module',
        'LearnMoreConstants'                : 'modules/learn-more/core/learn-more_constants',
        'LearnMoreSummaryController'     : 'modules/learn-more/pages/summary/learn-more-summary_controller',

        // Trackers Left-Hand Nav Feature
        'TrackersModule'                   		: 'modules/trackers/trackers_module',
        'TrackersConstants'                		: 'modules/trackers/core/trackers_constants',
        'TrackersService'                  		: 'modules/trackers/core/trackers_service',
        'TrackersSummaryController'        		: 'modules/trackers/pages/summary/trackers-summary_controller',
        'TrackersEntryController'          		: 'modules/trackers/pages/entry/trackers-entry_controller',
        'GraphService'					   		: 'modules/trackers/core/graph_service',

        'TrackerNavItemDateFilter'				: 'modules/trackers/core/tracker-nav-item-date-filter',
        'TrackersNavController'					: 'modules/trackers/pages/nav/trackers-nav_controller',
        'TrackersRemindersInstanceService'		: 'modules/trackers/core/trackers-reminders-instance_service',
		'TrackersRemindersConstants'			: 'modules/trackers/core/trackers-reminders_constants',
        'TrackersRemindersService'				: 'modules/trackers/core/trackers-reminders_service',
        'TrackersNotificationStatusController'	: 'modules/trackers/pages/notification-status/trackers-notification-status_controller',

		// Trackers FHIR Services
		'TrackersFHIRService'			: 'modules/trackers-fhir/trackers_fhir_service',
        'ExtensionFHIRService'			: 'modules/trackers-fhir/extension_fhir_service',
		'PatientFHIRService'			: 'modules/trackers-fhir/patient_fhir_service',
		'BpPulseFHIRService'			: 'modules/trackers-fhir/bp_pulse_fhir_service',
		'WeightFHIRService'				: 'modules/trackers-fhir/weight_fhir_service',
		'GlucoseFHIRService'			: 'modules/trackers-fhir/glucose_fhir_service',
        'CholesterolFHIRService'		: 'modules/trackers-fhir/cholesterol_fhir_service',
        'FitnessActivityFHIRService'		: 'modules/trackers-fhir/fitness_activity_fhir_service',
        'MoodFHIRService'			    : 'modules/trackers-fhir/mood_fhir_service',
        'FitnessGoalsFHIRService'			    : 'modules/trackers-fhir/fitness_goals_fhir_service',


        'HealthMoodModule'               : 'modules/health-mood/health-mood_module',
        'HealthMoodConstants'            : 'modules/health-mood/core/health-mood_constants',
        'HealthMoodService'              : 'modules/health-mood/core/health-mood_service',
        'HealthMoodGraphService'         : 'modules/health-mood/core/health-mood-graph_service',
        'HealthMoodSummaryController'    : 'modules/health-mood/pages/summary/health-mood-summary_controller',
        'HealthMoodEntryController'      : 'modules/health-mood/pages/entry/health-mood-entry_controller',
        'RemindersService'				 : 'modules/trackers/core/reminders_service',
        'MoodFeedbackConstants'			 : 'modules/health-mood/core/mood-feedback_constants',
        'MoodFeedbackService'			 : 'modules/health-mood/core/mood-feedback_service',

        //'NotificationDeliveryDirective'	         : 'modules/health-mood/pages/notification-status/notification-delivery-options/notification-delivery-options_directive',
        'NotificationDeliveryDirective'			: 'modules/trackers/pages/notification-status/notification-delivery-options/notification-delivery-options_directive',

        'NotificationDeliveryOptions'	: 'ui-components/form/controls/composite/notification-delivery-options/notification-delivery-options_directive',

        'HealthMoodRemindersInstanceService'     : 'modules/health-mood/core/health-mood-reminders-instance_service',
        'HealthMoodRemindersService'	         : 'modules/health-mood/core/health-mood-reminders_service',
        'HealthMoodNotificationStatusController' : 'modules/health-mood/pages/notification-status/health-mood-notification-status_controller',
        'AbstractHealthMoodService'      : 'modules/health-mood/core/abstract-health-mood_service',
        'HealthMoodServiceConstants'     : 'modules/health-mood/core/health-mood-service_constants',
        'HealthMoodNavController'        : 'modules/health-mood/pages/nav/health-mood-nav_controller',
        'HealthMoodNavItemDateFilter'    : 'modules/health-mood/core/health-mood-nav-item-date-filter',



        // Notifications Left-Hand Nav Feature
        'NotificationsModule'                   : 'modules/notifications/notifications_module',
        'NotificationsConstants'                : 'modules/notifications/core/notifications_constants',
        'NotificationsService'                  : 'modules/notifications/core/notifications_service',
        'NotificationsInstanceBuilderService'	: 'modules/notifications/core/notifications-instance-builder_service',
        'NotificationsSummaryController'        : 'modules/notifications/pages/summary/notifications-summary_controller',
        'NotificationsDetailsController'        : 'modules/notifications/pages/detail/notifications-details_controller',
        'NotificationSettingsController'		: 'modules/notifications/pages/notification-settings/notification-settings_controller',
        'NotificationSettingsService'			: 'modules/notifications/pages/notification-settings/notification-settings_service',

        //Home


		/*                  CORE COMPONENTS                    */
		'BaseCRUDService'				: 'core/services/base-crud_service',
		'CollectionCRUDService'			: 'core/services/collection-crud_service',

		'BaseCRUDMockService'			: 'core/services/base-crud-mock_service',

		'NotificationsPreferencesService' : 'core/resources/notifications-preferences_service',

		'httpInterceptor'				: 'core/connection/httpInterceptor',
		'connection_error_service'		: 'core/connection/connection_error_service',
		'connection_timeout_service'	: 'core/connection/connection_timeout_service',
		'delayManager'					: 'core/connection/delay_factory',

		'localResourceDirectoryService'	: 'core/resources/local-resource-directory_service',
		'patient'						: 'core/resources/patient_service',
		'userService'					: 'core/resources/user_service',

		'page_service'					: 'core/services/page_service',
		'formatter'						: 'core/services/formatter',
		'authentication_service'		: 'core/services/auth_service',
		'unsavedChanges'				: 'core/services/unsaved_changes',
		'focusManager'					: 'core/services/focus_directive',

		/*					FHIR COMPONENTS             */
		'FHIRModule'					: 'core/fhir-module/fhir_module',
		'RequestService'				: 'core/fhir-module/request_service',
		'BaseFHIRConfigProvider'		: 'core/fhir-module/base_fhir_config_provider',
		'BaseFHIRService'				: 'core/fhir-module/base_fhir_service',
		'FHIRPageableObjectFactory'		: 'core/fhir-module/fhir_pageable_object_factory',
        'fhirPatientService'            : 'core/resources/fhir-patient_service',
        'fhirResourcesService'      	: 'core/resources/fhir-resources_service',

		/*					UI-COMPONENTS             */
		'EntryForm'						: 'ui-components/form/entry-form/entry-form_directive',
		'FormControlWrapper'			: 'ui-components/form/controls/core/form-control-wrapper/form-control-wrapper_directive',
		'iOSKeyboard'					: 'ui-components/form/controls/core/iOS-keyboard/iOS-keyboard_directive',
    	'InputRange'					: 'ui-components/form/controls/simple/input-range/input-range_directive',
		'InputSelect'					: 'ui-components/form/controls/simple/input-select/input-select_directive',
		'InputText'						: 'ui-components/form/controls/simple/input-text/input-text_directive',
		'InputFile'						: 'ui-components/form/controls/simple/input-file/input-file_directive',
		'InputNumber'					: 'ui-components/form/controls/simple/input-number/input-number_directive',
		'InputPhone'					: 'ui-components/form/controls/simple/input-phone/input-phone_directive',
		'InputGroupCheckbox'			: 'ui-components/form/controls/simple/input-group-checkbox/input-group-checkbox_directive',
		'InputGroupRadio'				: 'ui-components/form/controls/simple/input-group-radio/input-group-radio_directive',
		'CalendarDatePicker'			: 'ui-components/form/controls/simple/calendar-date-picker/calendar-date-picker_directive',
		'InputCalendarDatePicker'		: 'ui-components/form/controls/composite/input-calendar-date-picker/input-calendar-date-picker_directive',
		'TimeControls'					: 'ui-components/form/controls/composite/input-time-picker/time-controls_directive',
		'MultiPhone'					: 'ui-components/form/controls/composite/input-multi-phone/multi-phone_directive',
		'MultiTime'						: 'ui-components/form/controls/composite/input-multi-time-picker/multi-time_directive',
        'UserInputPattern'				: 'ui-components/form/validation/user-input-pattern/user-input-pattern_directive',
		'ValidationSummary'				: 'ui-components/form/validation/validation-summary/validation-summary',
		'ErrorHandling'					: 'ui-components/form/validation/validation-summary/error-handling_directive',
		'RequiredField'					: 'ui-components/form/validation/required-field-indicator/required-field-indicator_directive',
		'modalService'					: 'ui-components/modals/helper/modal_service',
		'HelpController'				: 'ui-components/modals/help/help_controller',
		'AboutController'				: 'ui-components/modals/about/about_controller',
		'ResourcesController'			: 'ui-components/modals/resources/resources_controller',
		'NavBar'						: 'ui-components/nav-bar/nav-bar_directive',
		'FilterWrapper'					: 'ui-components/filter/filter-wrapper_directive',
		'StatusFilter'					: 'ui-components/filter/status-filter/status-filter_directive',
		'DataTableDirective'			: 'ui-components/table/table_directive',
		'AriaHidden'					: 'ui-components/accessibility/aria-hidden/aria-hidden_directive',
		'aDirecitve'					: 'ui-components/html-extensions/a_directive',
		'iDirecitve'					: 'ui-components/html-extensions/i_directive',
		'clamp'							: 'ui-components/line-clamp/clamp_directive',
		'BackButton'					: 'ui-components/back-button/back-button_directive',
		'disableNgAnimate'				: 'ui-components/disable-ng-animate/disable-ng-animate_directive',
		'imageLightbox'					: 'ui-components/image/image-lightbox_directive',
        'InputFloat'                    : 'ui-components/form/controls/simple/input-float/input-float_directive',

        'FilterButton'					: 'ui-components/filter-button/filter-button_directive',


        // ACCESSIBLE DIRECTIVES
        'AccessibleAccordion'			: 'ui-components/accordion/accessibleaccordion_directive',
        'accessibleCarousel'			: 'ui-components/carousel/accessible-carousel_directive',
        'AccessibleCarouselController'	: 'ui-components/carousel/accessible-carousel_controller',
        'accessibleTimePickerServices'	: 'ui-components/form/controls/simple/accessibletimepicker/accessibletimepicker_directive',
        'highcharts-more'				: '../libs/highcharts/js/highcharts-more.src',
        'UserGuideModule'				 : 'modules/user-guide/user-guide_module',
        'UserGuideConstants'			 : 'modules/user-guide/core/user-guide_constants',
        'UserGuideController'			 : 'modules/user-guide/pages/user-guide_controller',
        'EulaController'				: 'core/eula/eula_controller',
        'eula_service'					: 'core/eula/eula_service',
        'mhpuser_service'				: 'core/resources/mhpuser_service',
        'resourcedirectory_service'		: 'core/resources/resourcedirectory_service',

    },
	shim: {
		'angular'					: {deps: ['jQuery'], 'exports': 'angular'},
		'jQuery'					: {'exports': '$'},
		'lodash'					: {'exports': '_'},
		'highstocks'				: ['jQuery'],
		'highcharts-ng'				: ['angular'],
        'Modernizr'				: { exports: 'Modernizr' },
        'highcharts-3d'             : ['highstocks'],
        'moment'					: {'exports' : 'moment'},
		'moment-timezone'			: ['moment'],
		'clampjs'					: {'exports': '$clamp'},
		'angularSanitize'			: ['angular'],
		'angularUiUtils'			: ['angular'],
		'angularUiRouter'			: ['angular'],
		'angularUiBootstrap'		: ['angular'],
		'angularUiBootstrapOverwrites'		: ['angularUiBootstrap'],
		'angularTouch'				: ['angular'],
		'angularBusy'				: ['angular'],
		'angularSnap'				: ['angular', 'snap'],
		'angularAnimate'			: ['angular'],
		'templates'					: ['app'],
        'highcharts-more'           : ['highstocks'],
        'solid-gauge'               : ['highstocks', 'highcharts-more'],


	},
	priority: ['angular']
});

require(
	[
		'app',
        'angular',
        'angularTouch',
        'angularUiUtils',
        'angularUiRouter',
        'angularSanitize',
        'angularAnimate',
        'angularBusy',
        'AriaHidden',
        'AccessibleAccordion',
        'accessibleCarousel',
        'AccessibleCarouselController',
        'aDirecitve',
        'angularUiBootstrap',
        'angularUiBootstrapOverwrites',
        'appConfig',
        'BackButton',
        'localResourceDirectoryService',
        'BaseCRUDService',
        'clamp',
        'CollectionCRUDService',
        'DataTableDirective',
        'delayManager',
        'disableNgAnimate',
        'EntryForm',
        'ErrorHandling',
        'FilterButton',
        'FilterWrapper',
        'focusManager',
        'formatter',
        'FormControlWrapper',
        'global',
        'highstocks',
        'httpInterceptor',
        'iDirecitve',
        'InputGroupCheckbox',
        'InputGroupRadio',
        'InputNumber',
        'InputFloat',
        'InputRange',
        'InputSelect',
        'InputText',
        'iOSKeyboard',
        'List',
        'lodash',
        'Menu',
        'moment-timezone',
        'MultiTime',
        'NavBar',
        'ngClickDecoration',
        'ngMaskDecoration',
        'RequiredField',
        'router',
        'StatusFilter',
        'templates',
        'TwoPanelController',
        'uiCollapseDecoration',
        'unsavedChanges',
        'UserInputPattern',
        'ValidationSummary',
        'highcharts-3d',
        'highcharts-more',
        'solid-gauge',
        'localResourceDirectoryService'

	], function (app, angular) {
		'use strict';
		angular.element().ready(function () {
			angular.bootstrap(document, [app.name]);
		});
	});